<?php
require_once 'config.php';

$error = '';
$success = '';

if(!empty($_REQUEST['first_name']) && !empty($_REQUEST['last_name']) && !empty($_REQUEST['email']) && !empty($_REQUEST['password'])) {
    $first_name = trim($_REQUEST['first_name']);
    $last_name = trim($_REQUEST['last_name']);
    $email = trim($_REQUEST['email']);
    $password = $_REQUEST['password'];

    if(!empty($_REQUEST['confirm_password']) && $password != $_REQUEST['confirm_password']) {
        $error = 'Passwords do not match.';
    } else {
        $sql_check = "
            SELECT user_id
            FROM users
            WHERE email = ?
            LIMIT 1
            ";

        $stmt_check = $mysql->prepare($sql_check);

        if($stmt_check) {
            $stmt_check->bind_param('s', $email);
            $stmt_check->execute();
            $result_check = $stmt_check->get_result();

            if($result_check && $result_check->num_rows > 0) {
                $error = 'Email already exists. Please use a different email or login.';
                $stmt_check->close();
            } else {
                $stmt_check->close();

                $password_hash = password_hash($password, PASSWORD_DEFAULT);

                $sql = "
                    INSERT INTO users (first_name, last_name, email, password_hash, is_admin, created_at)
                    VALUES (?, ?, ?, ?, 0, NOW())
                    ";

                $stmt = $mysql->prepare($sql);

                if($stmt) {
                    $stmt->bind_param('ssss', $first_name, $last_name, $email, $password_hash);

                    if($stmt->execute()) {
                        $success = 'Account created successfully! Redirecting to login...';
                        header('Refresh: 2; url=login.php');
                    } else {
                        $error = 'Error creating account. Please try again.';
                    }
                    $stmt->close();
                } else {
                    $error = 'Database error. Please try again later.';
                }
            }
        } else {
            $error = 'Database error. Please try again later.';
        }
    }
}
?>
<html>
<head>
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-P8J7Y3RS27"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-P8J7Y3RS27');
    </script>
    <title>Create Account - Budget Buddy</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body class="login-page">
<div class="login-container">
    <div class="login-card">
        <div class="logo-container">
            <div class="logo-icon"><img src="logo2.png" alt="Logo" width="100" height="100" draggable="false"/></div>
        </div>
        <h1 class="page-title">Create New Account</h1>
        <p class="page-subtitle">Sign up to start managing your budget</p>

        <?php if(!empty($error)) { ?>
            <div style="background:#fdecea; color:#b71c1c; padding:12px 16px; border-radius:8px; margin-bottom:18px;">
                <?php echo $error; ?>
            </div>
        <?php } ?>

        <?php if(!empty($success)) { ?>
            <div style="background:#e8f5e9; color:#2e7d32; padding:12px 16px; border-radius:8px; margin-bottom:18px;">
                <?php echo $success; ?>
            </div>
        <?php } ?>

        <form class="login-form" method="post">
            <div class="form-group">
                <label for="first_name">First Name</label>
                <input type="text" id="first_name" name="first_name" placeholder="John" value="<?php echo !empty($_REQUEST['first_name']) ? htmlspecialchars($_REQUEST['first_name']) : ''; ?>" required>
            </div>

            <div class="form-group">
                <label for="last_name">Last Name</label>
                <input type="text" id="last_name" name="last_name" placeholder="Doe" value="<?php echo !empty($_REQUEST['last_name']) ? htmlspecialchars($_REQUEST['last_name']) : ''; ?>" required>
            </div>

            <div class="form-group">
                <label for="email">Email</label>
                <input type="email" id="email" name="email" placeholder="you@example.com" value="<?php echo !empty($_REQUEST['email']) ? htmlspecialchars($_REQUEST['email']) : ''; ?>" required>
            </div>

            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" placeholder="********" required>
            </div>

            <div class="form-group">
                <label for="confirm_password">Confirm Password</label>
                <input type="password" id="confirm_password" name="confirm_password" placeholder="********" required>
            </div>

            <button type="submit" class="login-button">Create Account</button>
        </form>

        <p class="demo-text" style="text-align: center; margin-top: 20px;">
            Already have an account? <a href="login.php" style="color: #1e3a5f; text-decoration: none;">Sign in here</a>
        </p>
    </div>
</div>
</body>
</html>
