<?php
require_once 'config.php';

if(session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

$login_error = '';

if(!empty($_SESSION['loggedin']) && $_SESSION['loggedin'] === 'yes') {
    header('Location: dashboard.php');
    exit();
}

if(!empty($_REQUEST['email']) && !empty($_REQUEST['password'])) {
    $email = trim($_REQUEST['email']);
    $password = $_REQUEST['password'];

    $sql = "
        SELECT user_id, first_name, last_name, password_hash, is_admin
        FROM users
        WHERE email = '" . $email . "'
        LIMIT 1
        ";

    $results = $mysql->query($sql);

    if(!$results) {
        $login_error = 'Database error: ' . $mysql->error;
    } else {
        if($results->num_rows > 0) {
            $user = $results->fetch_assoc();

            if(!empty($user['password_hash']) && password_verify($password, $user['password_hash'])) {
                session_regenerate_id(true);
                $_SESSION['loggedin'] = 'yes';
                $_SESSION['user_id'] = $user['user_id'];
                $_SESSION['user_name'] = trim($user['first_name'] . ' ' . $user['last_name']);
                $_SESSION['is_admin'] = intval($user['is_admin'] ?? 0);
                header('Location: dashboard.php');
                exit();
            } else {
                $login_error = 'Invalid email or password. Please try again.';
            }
        } else {
            $login_error = 'Invalid email or password. Please try again.';
        }
    }
}
?>
    <html>
    <head>
        <!-- Google tag (gtag.js) -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=G-P8J7Y3RS27"></script>
        <script>
          window.dataLayer = window.dataLayer || [];
          function gtag(){dataLayer.push(arguments);}
          gtag('js', new Date());
          gtag('config', 'G-P8J7Y3RS27');
        </script>
        <title>Login - Budget Buddy</title>
        <link rel="stylesheet" href="css/style.css">
    </head>
    <body class="login-page">
    <div class="login-container">
        <div class="login-card">
            <div class="logo-container">
                <div class="logo-icon"><img src="logo2.png" alt="Logo" width="100" height="100" draggable="false"/></div>
            </div>
            <h1 class="page-title">Budget Buddy Login</h1>
            <p class="page-subtitle">Enter your credentials to continue.</p>
            <?php if(!empty($login_error)) { ?>
                <div style="background:#fdecea; color:#b71c1c; padding:12px 16px; border-radius:8px; margin-bottom:18px;">
                    <?= $login_error; ?>
                </div>
            <?php } ?>
            <form class="login-form" method="post">
                <div class="form-group">
                    <label for="email">Email</label>
                    <input type="email" id="email" name="email" placeholder="you@example.com" value="<?= !empty($_REQUEST['email']) ? htmlspecialchars($_REQUEST['email']) : ''; ?>">
                </div>
                <div class="form-group">
                    <label for="password">Password</label>
                    <input type="password" id="password" name="password" placeholder="********">
                </div>
                <button type="submit" class="login-button">Sign In</button>
            </form>
            <p class="demo-text" style="text-align: center;">
                Don't have an account? <a href="signup.php" style="color: #1e3a5f; text-decoration: none;">Create one here</a>
            </p>
        </div>
    </div>
    </body>
    </html>
<?php
exit();
?>