<?php
require_once 'config.php';
include 'security.php';

$user_id = isset($_SESSION['user_id']) ? intval($_SESSION['user_id']) : 0;
if ($user_id <= 0) { header('Location: login.php'); exit(); }

// Check if user needs walkthrough (less than 5 transactions)
$transaction_count_sql = "SELECT COUNT(*) as total FROM transactions WHERE account_id IN (
    SELECT account_id FROM accounts WHERE user_id = " . $user_id . "
)";
$transaction_count_result = $mysql->query($transaction_count_sql);
$show_walkthrough = false;
$walkthrough_dismissed = isset($_SESSION['walkthrough_dismissed']) ? $_SESSION['walkthrough_dismissed'] : false;

if($transaction_count_result && $transaction_count_result->num_rows > 0) {
    $count_row = $transaction_count_result->fetch_assoc();
    $total_transactions = intval($count_row['total']);
    if($total_transactions < 5 && !$walkthrough_dismissed) {
        $show_walkthrough = true;
    }
}

// Handle walkthrough dismissal
if(isset($_GET['dismiss_walkthrough']) && $_GET['dismiss_walkthrough'] == 1) {
    $_SESSION['walkthrough_dismissed'] = true;
    header('Location: dashboard.php');
    exit();
}

// Get selected account filter
$selected_account_id = isset($_GET['account']) ? intval($_GET['account']) : 0;

// Get user's accounts for the filter dropdown
$accounts_sql = "SELECT account_id, name FROM accounts WHERE user_id = " . $user_id . " ORDER BY name";
$accounts_result = $mysql->query($accounts_sql);
$accounts = [];
if($accounts_result) {
    while($row = $accounts_result->fetch_assoc()) {
        $accounts[] = $row;
    }
}

// Build account filter condition
$account_filter = "";
if($selected_account_id > 0) {
    // Verify account belongs to user
    $verify_account = $mysql->query("SELECT account_id FROM accounts WHERE account_id = " . $selected_account_id . " AND user_id = " . $user_id);
    if($verify_account && $verify_account->num_rows > 0) {
        $account_filter = " AND t.account_id = " . $selected_account_id;
    } else {
        $selected_account_id = 0; // Reset if invalid
    }
} else {
    // Include all accounts (user's accounts + shared accounts)
    $account_filter = " AND t.account_id IN (
        SELECT account_id FROM accounts WHERE user_id = " . $user_id . "
        UNION
        SELECT account_id FROM shared_users WHERE user_id = " . $user_id . "
    )";
}

// SUMMARY CARDS
$income_total = 0;
$expense_total = 0;
$balance_total = 0;

$month_start = date('Y-m-01');

// Get income and expense totals for current month
if($selected_account_id > 0) {
    // Filter by specific account
    $sql = "
      SELECT 
        COALESCE(SUM(CASE WHEN c.type = 'income' THEN t.amount ELSE 0 END), 0) as total_income,
        COALESCE(SUM(CASE WHEN c.type = 'expense' THEN ABS(t.amount) ELSE 0 END), 0) as total_expense
      FROM transactions t
      LEFT JOIN categories c ON t.category_id = c.category_id
      WHERE t.account_id = {$selected_account_id}
        AND DATE_FORMAT(t.transaction_date, '%Y-%m-01') = '{$month_start}'
    ";
    $results = $mysql->query($sql);
    if($results && $results->num_rows > 0) {
        $row = $results->fetch_assoc();
        $income_total  = (float)($row['total_income'] ?? 0);
        $expense_total = (float)($row['total_expense'] ?? 0);
    }

    // Get total balance for selected account
    $bal_sql = "
      SELECT COALESCE(SUM(amount), 0) AS total_balance
      FROM transactions
      WHERE account_id = {$selected_account_id}
    ";
    $bal_res = $mysql->query($bal_sql);
    if ($bal_res && $bal_res->num_rows > 0) {
        $bal_row = $bal_res->fetch_assoc();
        $balance_total = (float)($bal_row['total_balance'] ?? 0);
    }
} else {
    // Use views for all accounts
    $sql = "
      SELECT total_income, total_expense, net
      FROM v_monthly_user_summary
      WHERE user_id = {$user_id}
        AND month_start = '{$month_start}'
      LIMIT 1
    ";
    $results = $mysql->query($sql);
    if(!$results){
        echo "<hr>Your SQL:<br>$sql<br><br>SQL Error: ".$mysql->error."<hr>";
        exit();
    }

    if ($results->num_rows === 0) {
        $sql = "
        SELECT total_income, total_expense, net
        FROM v_monthly_user_summary
        WHERE user_id = {$user_id}
        ORDER BY month_start DESC
        LIMIT 1
      ";
        $results = $mysql->query($sql);
        if(!$results){
            echo "<hr>Your SQL:<br>$sql<br><br>SQL Error: ".$mysql->error."<hr>";
            exit();
        }
    }

    if ($results->num_rows > 0){
        $row = $results->fetch_assoc();
        $income_total  = (float)($row['total_income']  ?? 0);
        $expense_total = (float)($row['total_expense'] ?? 0);
    }

    $bal_sql = "
      SELECT SUM(net) AS total_balance
      FROM v_monthly_user_summary
      WHERE user_id = {$user_id}
    ";
    $bal_res = $mysql->query($bal_sql);
    if ($bal_res && $bal_res->num_rows > 0) {
        $bal_row = $bal_res->fetch_assoc();
        $balance_total = (float)($bal_row['total_balance'] ?? 0);
    }
}

// LINE CHART DATA
if($selected_account_id > 0) {
    // Filter by specific account
    $line_sql = "
      SELECT 
        DATE_FORMAT(t.transaction_date, '%Y-%m-01') as month_start,
        COALESCE(SUM(CASE WHEN c.type = 'income' THEN t.amount ELSE 0 END), 0) as total_income,
        COALESCE(SUM(CASE WHEN c.type = 'expense' THEN ABS(t.amount) ELSE 0 END), 0) as total_expense
      FROM transactions t
      LEFT JOIN categories c ON t.category_id = c.category_id
      WHERE t.account_id = {$selected_account_id}
        AND DATE_FORMAT(t.transaction_date, '%Y-%m-01') >= CAST(DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 5 MONTH), '%Y-%m-01') AS DATE)
      GROUP BY DATE_FORMAT(t.transaction_date, '%Y-%m-01')
      ORDER BY month_start
    ";
} else {
    // Use view for all accounts
    $line_sql = "
      SELECT month_start, total_income, total_expense
      FROM v_line_income_expense
      WHERE user_id = {$user_id}
        AND month_start >= CAST(DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 5 MONTH), '%Y-%m-01') AS DATE)
      ORDER BY month_start
    ";
}
$line_res = $mysql->query($line_sql);
$line_labels = []; $line_income = []; $line_expense = [];
if ($line_res) {
    while ($r = $line_res->fetch_assoc()){
        $line_labels[]  = date('M Y', strtotime($r['month_start']));
        $line_income[]  = (float)$r['total_income'];
        $line_expense[] = (float)$r['total_expense'];
    }
}

// PIE CHART DATA
if($selected_account_id > 0) {
    // Filter by specific account
    $pie_sql = "
      SELECT 
        c.label as category_label,
        COALESCE(SUM(ABS(t.amount)), 0) as category_expense
      FROM transactions t
      LEFT JOIN categories c ON t.category_id = c.category_id
      WHERE t.account_id = {$selected_account_id}
        AND c.type = 'expense'
        AND DATE_FORMAT(t.transaction_date, '%Y-%m-01') = CAST(DATE_FORMAT(CURDATE(), '%Y-%m-01') AS DATE)
      GROUP BY c.category_id, c.label
      ORDER BY category_expense DESC
    ";
    $pie_res = $mysql->query($pie_sql);
    $pie_labels = []; $pie_values = []; $pie_percents = [];
    $total_expense_for_pie = $expense_total;
    if ($pie_res) {
        while ($r = $pie_res->fetch_assoc()){
            $pie_labels[] = $r['category_label'];
            $expense_val = (float)$r['category_expense'];
            $pie_values[] = $expense_val;
            $pie_percents[] = $total_expense_for_pie > 0 ? round(($expense_val / $total_expense_for_pie) * 100, 1) : 0;
        }
    }
} else {
    // Use view for all accounts
    $pie_sql = "
      SELECT category_label, category_expense, percent_of_month
      FROM v_pie_spend_by_category
      WHERE user_id = {$user_id}
        AND month_start = CAST(DATE_FORMAT(CURDATE(), '%Y-%m-01') AS DATE)
      ORDER BY category_expense DESC
    ";
    $pie_res = $mysql->query($pie_sql);
    $pie_labels = []; $pie_values = []; $pie_percents = [];
    if ($pie_res) {
        while ($r = $pie_res->fetch_assoc()){
            $pie_labels[]   = $r['category_label'];
            $pie_values[]   = (float)$r['category_expense'];
            $pie_percents[] = (float)$r['percent_of_month'];
        }
    }
}

$current_month = date('F Y');
?>

<html>
<head>
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-P8J7Y3RS27"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-P8J7Y3RS27');
    </script>
    <title>Dashboard - Budget Buddy</title>
    <link rel="stylesheet" href="css/style.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>

    <!-- Walkthrough CSS -->
    <style>
        .walkthrough-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.75);
            z-index: 9998;
            display: none;
        }

        .walkthrough-overlay.active {
            display: block;
        }

        .walkthrough-spotlight {
            position: fixed;
            pointer-events: none;
            z-index: 9999;
            box-shadow: 0 0 0 9999px rgba(0, 0, 0, 0.75);
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .walkthrough-tooltip {
            position: absolute;
            background: white;
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.3);
            max-width: 320px;
            z-index: 9999;
            display: none;
            animation: tooltipFadeIn 0.3s ease;
        }

        .walkthrough-tooltip.active {
            display: block;
        }

        @keyframes tooltipFadeIn {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .walkthrough-tooltip-header {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 12px;
            padding-bottom: 12px;
            border-bottom: 2px solid #f0f0f0;
        }

        .walkthrough-tooltip-icon {
            font-size: 28px;
        }

        .walkthrough-tooltip-title {
            font-size: 18px;
            font-weight: 600;
            color: #333;
        }

        .walkthrough-tooltip-content {
            font-size: 14px;
            line-height: 1.6;
            color: #666;
            margin-bottom: 16px;
        }

        .walkthrough-tooltip-footer {
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 10px;
        }

        .walkthrough-progress {
            font-size: 12px;
            color: #999;
            font-weight: 500;
        }

        .walkthrough-buttons {
            display: flex;
            gap: 8px;
        }

        .walkthrough-btn {
            padding: 8px 16px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
            transition: all 0.2s;
        }

        .walkthrough-btn-skip {
            background: #f5f5f5;
            color: #666;
        }

        .walkthrough-btn-skip:hover {
            background: #e0e0e0;
        }

        .walkthrough-btn-next {
            background: #1e3a5f;
            color: white;
        }

        .walkthrough-btn-next:hover {
            background: #152a47;
        }

        .walkthrough-btn-prev {
            background: #e0e0e0;
            color: #333;
        }

        .walkthrough-btn-prev:hover {
            background: #d0d0d0;
        }

        .walkthrough-highlight {
            position: relative;
            z-index: 10000 !important;
            box-shadow: 0 0 0 4px rgb(30, 58, 95), 0 0 20px rgb(21, 42, 71) !important;
            border-radius: 8px;
            background: white !important;
        }

        .walkthrough-highlight * {
            position: relative;
            z-index: 10001 !important;
        }

        .walkthrough-arrow {
            position: absolute;
            width: 0;
            height: 0;
            border-style: solid;
        }

        .walkthrough-arrow-top {
            top: -10px;
            left: 50%;
            transform: translateX(-50%);
            border-width: 0 10px 10px 10px;
            border-color: transparent transparent white transparent;
        }

        .walkthrough-arrow-bottom {
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            border-width: 10px 10px 0 10px;
            border-color: white transparent transparent transparent;
        }

        .walkthrough-arrow-left {
            left: -10px;
            top: 50%;
            transform: translateY(-50%);
            border-width: 10px 10px 10px 0;
            border-color: transparent white transparent transparent;
        }

        .walkthrough-arrow-right {
            right: -10px;
            top: 50%;
            transform: translateY(-50%);
            border-width: 10px 0 10px 10px;
            border-color: transparent transparent transparent white;
        }
    </style>
    </style>
</head>
<body class="dashboard-page">
<?php $active_page = 'dashboard'; include 'sidebar.php'; ?>

<main class="main-content">
    <div class="page-header" style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 15px;">
        <div>
            <h1 class="page-title">Dashboard</h1>
            <p class="page-subtitle">Overview of your budget for <?php echo htmlspecialchars($current_month); ?></p>
        </div>
        <div style="display: flex; align-items: center; gap: 10px;">
            <label for="account-filter" style="font-size: 14px; color: #666; font-weight: 500;">Filter by Account:</label>
            <form method="GET" action="dashboard.php" style="display: inline-block;">
                <select id="account-filter" name="account" onchange="this.form.submit()" style="padding: 8px 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px; background: white; cursor: pointer; min-width: 200px;">
                    <option value="0" <?php echo $selected_account_id == 0 ? 'selected' : ''; ?>>All Accounts</option>
                    <?php foreach($accounts as $acc): ?>
                        <option value="<?php echo $acc['account_id']; ?>" <?php echo $selected_account_id == $acc['account_id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($acc['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </form>
        </div>
    </div>

    <div class="cards-row">
        <div class="summary-card">
            <div class="card-header"><h3 class="card-title">Total Balance</h3><span class="card-icon">💼</span></div>
            <div class="card-value">$<?php echo number_format($balance_total, 2); ?></div>
            <div class="card-context">Current balance</div>
        </div>

        <div class="summary-card">
            <div class="card-header"><h3 class="card-title">Income</h3><span class="card-icon">📈</span></div>
            <div class="card-value income-color">$<?php echo number_format($income_total, 2); ?></div>
            <div class="card-context">This month's income</div>
        </div>

        <div class="summary-card">
            <div class="card-header"><h3 class="card-title">Expenses</h3><span class="card-icon">📉</span></div>
            <div class="card-value expense-color">$<?php echo number_format($expense_total, 2); ?></div>
            <div class="card-context">This month's expenses</div>
        </div>
    </div>

    <div class="cards-row">
        <!-- LINE CHART -->
        <div class="chart-card">
            <div class="card-header">
                <h3 class="card-title">Income vs Expenses</h3>
                <span class="card-context">Last 6 months</span>
            </div>
            <div class="chart-placeholder">
                <canvas id="lineChart"></canvas>
            </div>
        </div>

        <!-- PIE CHART -->
        <div class="chart-card">
            <div class="card-header">
                <h3 class="card-title">Spending by Category</h3>
                <span class="card-context">This month</span>
            </div>
            <div class="chart-placeholder">
                <canvas id="pieChart"></canvas>
            </div>
        </div>
    </div>
</main>

<!-- Walkthrough Overlay and Tooltip -->
<?php if($show_walkthrough): ?>
    <div class="walkthrough-overlay" id="walkthroughOverlay"></div>
    <div class="walkthrough-spotlight" id="walkthroughSpotlight" style="display: none;"></div>
    <div class="walkthrough-tooltip" id="walkthroughTooltip">
        <div class="walkthrough-tooltip-header">
            <span class="walkthrough-tooltip-icon" id="tooltipIcon">👋</span>
            <span class="walkthrough-tooltip-title" id="tooltipTitle">Welcome!</span>
        </div>
        <div class="walkthrough-tooltip-content" id="tooltipContent">
            Let's get you started with Budget Buddy! This quick tutorial will show you how to manage your finances.
        </div>
        <div class="walkthrough-tooltip-footer">
            <span class="walkthrough-progress" id="tooltipProgress">Step 1 of 6</span>
            <div class="walkthrough-buttons">
                <button class="walkthrough-btn walkthrough-btn-skip" onclick="skipWalkthrough()">Skip Tutorial</button>
                <button class="walkthrough-btn walkthrough-btn-prev" id="prevBtn" style="display: none;" onclick="previousStep()">Previous</button>
                <button class="walkthrough-btn walkthrough-btn-next" id="nextBtn" onclick="nextStep()">Next</button>
            </div>
        </div>
        <div class="walkthrough-arrow walkthrough-arrow-top" id="tooltipArrow"></div>
    </div>
<?php endif; ?>

<script>
    // Wait for DOM to be fully loaded
    document.addEventListener('DOMContentLoaded', function() {
        // Data from PHP
        const lineLabels  = <?php echo json_encode($line_labels); ?>;
        const lineIncome  = <?php echo json_encode($line_income); ?>;
        const lineExpense = <?php echo json_encode($line_expense); ?>;

        const pieLabels   = <?php echo json_encode($pie_labels); ?>;
        const pieValues   = <?php echo json_encode($pie_values); ?>;
        const piePercents = <?php echo json_encode($pie_percents); ?>;

        // Line chart
        const ctxLine = document.getElementById('lineChart');
        new Chart(ctxLine, {
            type: 'line',
            data: {
                labels: lineLabels,
                datasets: [
                    { label: 'Income',   data: lineIncome,  tension: 0.3 },
                    { label: 'Expenses', data: lineExpense, tension: 0.3 }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: { legend: { position: 'bottom' } },
                scales: { y: { beginAtZero: true } }
            }
        });

        // Pie chart
        const ctxPie = document.getElementById('pieChart');
        new Chart(ctxPie, {
            type: 'pie',
            data: {
                labels: pieLabels,
                datasets: [{ data: pieValues }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: { position: 'right' },
                    tooltip: {
                        callbacks: {
                            label: (context) => {
                                const label = context.label || '';
                                const value = context.parsed || 0;
                                const pct = piePercents?.[context.dataIndex] ?? 0;
                                return `${label}: ${Number(value).toFixed(2)} (${pct}%)`;
                            }
                        }
                    }
                }
            }
        });

        <?php if($show_walkthrough): ?>
        // Start walkthrough after a short delay
        setTimeout(() => showStep(0), 800);
        <?php endif; ?>
    });

    <?php if($show_walkthrough): ?>
    // Walkthrough configuration for Dashboard
    const walkthroughSteps = [
        {
            icon: '👋',
            title: 'Welcome to Budget Buddy!',
            content: 'Let\'s take a quick tour to help you get started. This tutorial will guide you through the essential features. You can skip it anytime!',
            target: null,
            position: 'center'
        },
        {
            icon: '💼',
            title: 'Your Financial Overview',
            content: 'These cards show your total balance, monthly income, and expenses at a glance. They update automatically as you add transactions.',
            target: '.cards-row:first-of-type',
            position: 'bottom'
        },
        {
            icon: '📊',
            title: 'Visual Insights',
            content: 'Track your financial trends with interactive charts. The line chart shows income vs expenses over 6 months, while the pie chart breaks down spending by category.',
            target: '.cards-row:last-of-type',
            position: 'top'
        },
        {
            icon: '🏦',
            title: 'Step 1: Add an Account',
            content: 'Start by creating a bank account. Click "Add Account" in the sidebar to set up your first account (checking, savings, credit card, etc.).',
            target: 'a[href="add_account.php"]',
            position: 'right'
        },
        {
            icon: '💰',
            title: 'Step 2: Record Income',
            content: 'After creating an account, add your income sources like salary, freelance work, or investments using the "Add Income" page.',
            target: 'a[href="add_income.php"]',
            position: 'right'
        },
        {
            icon: '📉',
            title: 'Step 3: Track Expenses',
            content: 'Record your spending by adding expenses. Categorize them to see where your money goes each month.',
            target: 'a[href="add_expense.php"]',
            position: 'right'
        },
        {
            icon: '✅',
            title: 'You\'re Ready!',
            content: 'That\'s it! Start by adding an account, then record transactions. Your dashboard will automatically update with insights. Happy budgeting!',
            target: null,
            position: 'center'
        }
    ];

    let currentStep = 0;
    let totalSteps = walkthroughSteps.length;

    function showStep(stepIndex) {
        if(stepIndex < 0 || stepIndex >= totalSteps) return;

        currentStep = stepIndex;
        const step = walkthroughSteps[stepIndex];

        // Update tooltip content
        document.getElementById('tooltipIcon').textContent = step.icon;
        document.getElementById('tooltipTitle').textContent = step.title;
        document.getElementById('tooltipContent').textContent = step.content;
        document.getElementById('tooltipProgress').textContent = `Step ${stepIndex + 1} of ${totalSteps}`;

        // Update buttons
        const prevBtn = document.getElementById('prevBtn');
        const nextBtn = document.getElementById('nextBtn');

        prevBtn.style.display = stepIndex > 0 ? 'inline-block' : 'none';
        nextBtn.textContent = stepIndex === totalSteps - 1 ? 'Finish' : 'Next';

        // Position tooltip
        positionTooltip(step);

        // Show overlay and tooltip
        document.getElementById('walkthroughOverlay').classList.add('active');
        document.getElementById('walkthroughTooltip').classList.add('active');
    }

    function positionTooltip(step) {
        const tooltip = document.getElementById('walkthroughTooltip');
        const arrow = document.getElementById('tooltipArrow');
        const spotlight = document.getElementById('walkthroughSpotlight');

        // Remove all highlight classes
        document.querySelectorAll('.walkthrough-highlight').forEach(el => {
            el.classList.remove('walkthrough-highlight');
        });

        // Remove all arrow classes
        arrow.className = 'walkthrough-arrow';

        if(!step.target || step.position === 'center') {
            // Center position
            tooltip.style.position = 'fixed';
            tooltip.style.top = '50%';
            tooltip.style.left = '50%';
            tooltip.style.transform = 'translate(-50%, -50%)';
            arrow.style.display = 'none';
            spotlight.style.display = 'none';
            return;
        }

        const target = document.querySelector(step.target);
        if(!target) {
            // Fallback to center if target not found
            tooltip.style.position = 'fixed';
            tooltip.style.top = '50%';
            tooltip.style.left = '50%';
            tooltip.style.transform = 'translate(-50%, -50%)';
            arrow.style.display = 'none';
            spotlight.style.display = 'none';
            return;
        }

        // Highlight target with spotlight effect
        target.classList.add('walkthrough-highlight');
        target.scrollIntoView({ behavior: 'smooth', block: 'center' });

        // Wait for scroll, then position
        setTimeout(() => {
            const rect = target.getBoundingClientRect();
            const tooltipRect = tooltip.getBoundingClientRect();

            // Position spotlight
            spotlight.style.display = 'block';
            spotlight.style.top = rect.top + 'px';
            spotlight.style.left = rect.left + 'px';
            spotlight.style.width = rect.width + 'px';
            spotlight.style.height = rect.height + 'px';

            tooltip.style.position = 'fixed';
            arrow.style.display = 'block';

            switch(step.position) {
                case 'top':
                    tooltip.style.left = rect.left + (rect.width / 2) - (tooltipRect.width / 2) + 'px';
                    tooltip.style.top = rect.top - tooltipRect.height - 20 + 'px';
                    tooltip.style.transform = 'none';
                    arrow.classList.add('walkthrough-arrow-bottom');
                    break;
                case 'bottom':
                    tooltip.style.left = rect.left + (rect.width / 2) - (tooltipRect.width / 2) + 'px';
                    tooltip.style.top = rect.bottom + 20 + 'px';
                    tooltip.style.transform = 'none';
                    arrow.classList.add('walkthrough-arrow-top');
                    break;
                case 'left':
                    tooltip.style.left = rect.left - tooltipRect.width - 20 + 'px';
                    tooltip.style.top = rect.top + (rect.height / 2) - (tooltipRect.height / 2) + 'px';
                    tooltip.style.transform = 'none';
                    arrow.classList.add('walkthrough-arrow-right');
                    break;
                case 'right':
                    tooltip.style.left = rect.right + 20 + 'px';
                    tooltip.style.top = rect.top + (rect.height / 2) - (tooltipRect.height / 2) + 'px';
                    tooltip.style.transform = 'none';
                    arrow.classList.add('walkthrough-arrow-left');
                    break;
            }
        }, 300);
    }

    function nextStep() {
        if(currentStep === totalSteps - 1) {
            finishWalkthrough();
        } else {
            showStep(currentStep + 1);
        }
    }

    function previousStep() {
        if(currentStep > 0) {
            showStep(currentStep - 1);
        }
    }

    function skipWalkthrough() {
        if(confirm('Are you sure you want to skip the tutorial? You can always explore the features on your own!')) {
            finishWalkthrough();
        }
    }

    function finishWalkthrough() {
        document.getElementById('walkthroughOverlay').classList.remove('active');
        document.getElementById('walkthroughTooltip').classList.remove('active');
        document.getElementById('walkthroughSpotlight').style.display = 'none';
        document.querySelectorAll('.walkthrough-highlight').forEach(el => {
            el.classList.remove('walkthrough-highlight');
        });

        // Dismiss walkthrough permanently
        window.location.href = 'dashboard.php?dismiss_walkthrough=1';
    }

    // Reposition on window resize
    window.addEventListener('resize', function() {
        if(currentStep >= 0 && currentStep < totalSteps) {
            positionTooltip(walkthroughSteps[currentStep]);
        }
    });
    <?php endif; ?>
</script>
</body>
</html>