<?php
require_once '../config.php';
require_once '../security.php';

// Check if user is admin (is_admin = 1)
$user_id = isset($_SESSION['user_id']) ? intval($_SESSION['user_id']) : 0;
if($user_id <= 0) {
    header('Location: ../login.php');
    exit();
}

// Check admin status
$admin_sql = "SELECT is_admin FROM users WHERE user_id = " . $user_id . " LIMIT 1";
$admin_result = $mysql->query($admin_sql);
$is_admin = false;
if($admin_result && $admin_result->num_rows > 0) {
    $user_data = $admin_result->fetch_assoc();
    $is_admin = (intval($user_data['is_admin'] ?? 0) == 1);
}

if(!$is_admin) {
    header('Location: ../dashboard.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-P8J7Y3RS27"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-P8J7Y3RS27');
    </script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Administration - Budget Buddy</title>
    <link rel="stylesheet" href="../css/style.css">
    <link rel="stylesheet" href="../css/admin.css">
</head>
<body class="admin-page">
    <?php include 'admin_nav.php'; ?>
    
    <main class="admin-main-content">
        <div class="admin-header">
            <h1>Administration</h1>
            <p class="admin-subtitle">Manage site data and content</p>
        </div>

        <div class="admin-modules-grid">
            <div class="admin-module-card">
                <div class="module-icon">💵</div>
                <h2>Transactions</h2>
                <p>Add, edit, and delete transactions</p>
                <div class="module-status">
                    <span class="status-badge implemented">✓ Implemented</span>
                </div>
                <a href="transactions.php" class="module-link">Manage Transactions →</a>
            </div>

            <div class="admin-module-card">
                <div class="module-icon">👥</div>
                <h2>Users</h2>
                <p>Manage user accounts and permissions</p>
                <div class="module-status">
                    <span class="status-badge implemented">✓ Implemented</span>
                </div>
                <a href="users.php" class="module-link">Manage Users →</a>
            </div>

            <div class="admin-module-card">
                <div class="module-icon">📁</div>
                <h2>Categories</h2>
                <p>Manage transaction categories</p>
                <div class="module-status">
                    <span class="status-badge planned">Planned</span>
                </div>
                <a href="#" class="module-link disabled">Coming Soon</a>
            </div>

            <div class="admin-module-card">
                <div class="module-icon">💼</div>
                <h2>Accounts</h2>
                <p>Manage user accounts</p>
                <div class="module-status">
                    <span class="status-badge planned">Planned</span>
                </div>
                <a href="#" class="module-link disabled">Coming Soon</a>
            </div>

            <div class="admin-module-card">
                <div class="module-icon">📊</div>
                <h2>Reports</h2>
                <p>View system-wide reports and analytics</p>
                <div class="module-status">
                    <span class="status-badge planned">Planned</span>
                </div>
                <a href="#" class="module-link disabled">Coming Soon</a>
            </div>

            <div class="admin-module-card">
                <div class="module-icon">⚙️</div>
                <h2>Settings</h2>
                <p>Configure system settings</p>
                <div class="module-status">
                    <span class="status-badge planned">Planned</span>
                </div>
                <a href="#" class="module-link disabled">Coming Soon</a>
            </div>
        </div>

        <div class="admin-stats">
            <h2>Quick Stats</h2>
            <div class="stats-grid">
                <?php
                // Get total transactions count
                $total_transactions_sql = "SELECT COUNT(*) as total FROM transactions";
                $total_transactions_result = $mysql->query($total_transactions_sql);
                $total_transactions = 0;
                if($total_transactions_result && $total_transactions_result->num_rows > 0) {
                    $row = $total_transactions_result->fetch_assoc();
                    $total_transactions = intval($row['total']);
                }

                // Get total users count
                $total_users_sql = "SELECT COUNT(*) as total FROM users";
                $total_users_result = $mysql->query($total_users_sql);
                $total_users = 0;
                if($total_users_result && $total_users_result->num_rows > 0) {
                    $row = $total_users_result->fetch_assoc();
                    $total_users = intval($row['total']);
                }

                // Get total accounts count
                $total_accounts_sql = "SELECT COUNT(*) as total FROM accounts";
                $total_accounts_result = $mysql->query($total_accounts_sql);
                $total_accounts = 0;
                if($total_accounts_result && $total_accounts_result->num_rows > 0) {
                    $row = $total_accounts_result->fetch_assoc();
                    $total_accounts = intval($row['total']);
                }
                ?>
                <div class="stat-card">
                    <div class="stat-value"><?php echo number_format($total_transactions); ?></div>
                    <div class="stat-label">Total Transactions</div>
                </div>
                <div class="stat-card">
                    <div class="stat-value"><?php echo number_format($total_users); ?></div>
                    <div class="stat-label">Total Users</div>
                </div>
                <div class="stat-card">
                    <div class="stat-value"><?php echo number_format($total_accounts); ?></div>
                    <div class="stat-label">Total Accounts</div>
                </div>
            </div>
        </div>

        <div class="admin-analytics-section">
            <h2>Website Analytics</h2>
            <p class="analytics-description">Website performance and user engagement metrics tracked with Google Analytics</p>
            <div class="analytics-images-grid">
                <div class="analytics-image-container">
                    <img src="Userstats.png" alt="User Statistics" class="analytics-image">
                </div>
                <div class="analytics-image-container">
                    <img src="Newusersdirect.png" alt="New Users by Channel" class="analytics-image">
                </div>
                <div class="analytics-image-container">
                    <img src="Newvsreturning.png" alt="New vs Returning Users" class="analytics-image">
                </div>
            </div>
        </div>
    </main>

</body>
</html>

